;*****************************************************************************
;
;   3-wire control for 13cm Usertrx (LMX2335)
;   
;   Copyright 04/2002 Martin Liebeck, DL4ZX
;
;*****************************************************************************
;
;******************************  PIC12C508 Header ****************************
;
;
	LIST    p=12c508 ; PIC12C508 is the target processor
;
        __MAXRAM h'1F'		; RAM Definition
;
	__CONFIG b'00001010'	; Programmer Status
;				  Oscillator:		Internal RC
; 				  Watch Dog Timer: 	Off
;				  Code Protect:		Off
;				  Master Clear:		Internal
;
;**************************************************************************
;
;  REGISTER
IND0    equ     00h
RTCC    equ     01h
PC      equ     02h
STATUS  equ     03h 
FSR     equ     04h
;
OSCCAL  equ     05h
GPIO	equ     06h 
;
;*************************************************************************
;
;  STATUS REG. Bits
C       equ     0h
DC      equ     1h
Z       equ     2h
PD      equ     3h
TO      equ     4h
GPWUF   equ     7h
;
;  OPTION REG. Bits                     
GPWU    equ     7h
GPPU    equ     6h
T0CE    equ     5h
T0SE    equ     4h
PSA     equ     3h
PS2     equ     2h
PS1     equ     1h
PS0     equ     0h
;
LSB     equ     0h
MSB     equ     7h
;
TRUE    equ     1h
YES     equ     1h
FALSE   equ     0h
NO      equ     0h
;
;  Bits:
;
chmask	EQU     b'00001111'
subband	EQU     4
zfqrg	EQU	5
;
;  3 wire bus
;
nclk	EQU	2		; Port clock line
ndata	EQU	0		; Port data line
nle	EQU	5		; Port enable line
TROUT	EQU	b'11011010'	; TRIS word for PLL program
TRIN	EQU	b'11011111'	; TRIS word for jumper test
TRSTART EQU	b'11111111'	; TRIS word for start
;
;  Files:
;
jold	EQU	07
jnew	EQU	08
channel	EQU	09
send	EQU	0A
temp	EQU	0B
jstart	EQU	0C

;*********************************************************************
;       Main loop
;*********************************************************************

	org	0		; start from reset

dly     clrw			; 0,4ms delay
	movwf   temp
dly1    decfsz  temp,f
	goto    dly1

	clrw
	option
	movlw	TRSTART
	tris	GPIO

	nop
	movf	GPIO,w		; read jumper state
  	movwf	jnew
	movwf	jstart

	goto	prog		; program PLL

mloop	clrwdt
	movf	GPIO,w		; read jumper state
	movwf	jnew
	subwf	jold,w		; compare with current jumper state
	btfsc	STATUS,Z
	goto	mloop		; no change

prog	movf	jnew,w
	movwf	jold		; update previous jumper state

;*******************************************************************
;	Program Counter
;*******************************************************************

	bsf	GPIO,nle
	bsf	GPIO,nclk
	movlw	TROUT
	tris	GPIO

	bcf	GPIO,nle	; program reference counter 1
	movlw	b'00010010'	; f=125kHz -> R=128
	movwf	send
	call	bysend
	movlw	b'00000010'
;	movlw	b'00110010'	; f=5kHz -> R=3200
	movwf	send
	call	bysend
	movlw	b'00000010'
	movwf	send
	call	bysend
	bsf	GPIO,nle

	bcf	GPIO,nle	; program reference counter 2
	movlw	b'00010010'	; f=12,5kHz -> R=1280
	movwf	send		; f=6,25kHz -> R=2560 for duplex-rx
	call	bysend
	movlw	b'00010100'
	btfss	jstart,zfqrg
	movlw	b'00101000'	; duplex-rx
	movwf	send
	call	bysend
	movlw	b'00000000'
	movwf	send
	call	bysend
	bsf	GPIO,nle

	movlw	chmask		; get channel number
	andwf	jnew,w
	movwf	channel		; channel 0 to 15
	bcf	STATUS,C
	rlf	channel,f	; increase division ratio by 2 per channel

	btfsc	jnew,subband	; test subband (2357/2392MHz)
	goto	prg1

	bcf	GPIO,nle	; program n-counter 1 low-band
	movlw	b'00000001'	; f0=2357,25, f0/2=1178,625
;	movlw	b'00011110'
	movwf	send		; -> B=147, A0=21, A15=51 
	call	bysend		
	movlw	b'00100110'
;	movlw	b'01100011'
	movwf	send
	call	bysend
	
	movlw	d'21'		; calculate A
	btfss	jstart,zfqrg
	movlw	d'25'		; 1MHz up for duplex-rx
	addwf	channel,f
	bsf	STATUS,C
	rlf	channel,f
	bsf	STATUS,C
	rlf	channel,w	; A0 would be b'01010111'
;	movlw	b'00110111'
	movwf	send
	call	bysend
	bsf	GPIO,nle
	goto	prg2

prg1	bcf	GPIO,nle	; program n-counter 1 high-band
	movlw	b'00000001'	; f0=2392,25, f0/2=1196,125
	movwf	send		; -> B=149, A0=33, A15=63
	call	bysend
	movlw	b'00101010'
	movwf	send
	call	bysend

	movlw	d'33'		; calculate A
	btfss	jstart,zfqrg
	movlw	d'29'		; 1MHz down for duplex-rx
	addwf	channel,f
	bsf	STATUS,C
	rlf	channel,f
	bsf	STATUS,C
	rlf	channel,w	; A0 would be b'10000111'
	movwf	send
	call	bysend
	bsf	GPIO,nle

prg2	bcf	GPIO,nle	; program n-counter 2
	movlw	b'00000000'	; f=45,7MHz -> B=57, A=8
	movwf	send
	call	bysend
	movlw	b'01110010'
	btfss	jstart,zfqrg
	movlw	b'11011110'	; B=111 for duplex-rx
	movwf	send
	call	bysend
	movlw	b'00100001'
	btfss	jstart,zfqrg
	movlw	b'11000001'	; A=48 for duplex-rx
	movwf	send
	call	bysend
	bsf	GPIO,nle
	
	nop
	movlw	TRIN
	tris	GPIO
	nop

	goto	mloop

;********************************************************************
;       Send one byte
;*********************************************************************

bysend	movlw	8
	movwf	temp
bys1	bcf	GPIO,nclk

	rlf	send,f
	btfsc	STATUS,C
	bsf	GPIO,ndata
	btfss	STATUS,C
	bcf	GPIO,ndata

	bsf	GPIO,nclk
	decfsz	temp,f
	goto	bys1
	retlw	0

	END
